<?php

use App\Http\Controllers\Api\AddressController;
use App\Http\Controllers\Api\AppPromptController;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Auth\EmailVerificationController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CityController;
use App\Http\Controllers\Api\CountryController;
use App\Http\Controllers\Api\DayOptionController;
use App\Http\Controllers\Api\DivisionController;
use App\Http\Controllers\Api\FoodController;
use App\Http\Controllers\Api\LanguageController;
use App\Http\Controllers\Api\LevelController;
use App\Http\Controllers\Api\OperationController;
use App\Http\Controllers\Api\PermissionController;
use App\Http\Controllers\Api\PreferencePromptController;
use App\Http\Controllers\Api\PromptController;
use App\Http\Controllers\Api\RecoveryController;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\ShelterController;
use App\Http\Controllers\Api\SubCategoryController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\VolunteerController;
use App\Http\Controllers\Api\WhenOptionController;
use App\Http\Controllers\Api\WhereOptionController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

/*
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
*/

Route::post("/signup", [AuthController::class, "signup"]);
Route::post('/login', [AuthController::class, 'login']);

Route::group(['middleware' => ["auth:sanctum"]], function () {
    Route::post('/logout', [AuthController::class, 'logout']);

    Route::prefix('admin-tool')->group(function () {
        Route::get("/day-options", [DayOptionController::class, "index"]);
        Route::get("/day-options/{id}", [DayOptionController::class, "show"]);
        Route::post("/day-options", [DayOptionController::class, "store"]);
        Route::put("/day-options/{id}", [DayOptionController::class, "update"]);
        Route::delete("/day-options/{id}", [DayOptionController::class, "destroy"]);

        Route::get("/where-options", [WhereOptionController::class, "index"]);
        Route::get("/where-options/{id}", [WhereOptionController::class, "show"]);
        Route::post("/where-options", [WhereOptionController::class, "store"]);
        Route::put("/where-options/{id}", [WhereOptionController::class, "update"]);
        Route::delete("/where-options/{id}", [WhereOptionController::class, "destroy"]);

        Route::get("/when-options", [WhenOptionController::class, "index"]);
        Route::get("/when-options/{id}", [WhenOptionController::class, "show"]);
        Route::post("/when-options", [WhenOptionController::class, "store"]);
        Route::put("/when-options/{id}", [WhenOptionController::class, "update"]);
        Route::delete("/when-options/{id}", [WhenOptionController::class, "destroy"]);

        Route::get("/operations", [OperationController::class, "index"]);
        Route::get("/operations/{id}", [OperationController::class, "show"]);
        Route::post("/operations", [OperationController::class, "store"]);
        Route::put("/operations/{id}", [OperationController::class, "update"]);
        Route::delete("/operations/{id}", [OperationController::class, "destroy"]);

        Route::get("/categories", [CategoryController::class, "index"]);
        Route::get("/categories/{id}", [CategoryController::class, "show"]);
        Route::get("/categories/{id}/sub-categories", [SubCategoryController::class, "showByCategoryId"]);
        Route::post("/categories", [CategoryController::class, "store"]);
        Route::put("/categories/{id}", [CategoryController::class, "update"]);
        Route::delete("/categories/{id}", [CategoryController::class, "destroy"]);

        Route::get("/sub-categories", [SubCategoryController::class, "index"]);
        Route::get("/sub-categories/{id}", [SubCategoryController::class, "show"]);
        Route::post("/sub-categories", [SubCategoryController::class, "store"]);
        Route::put("/sub-categories/{id}", [SubCategoryController::class, "update"]);
        Route::delete("/sub-categories/{id}", [SubCategoryController::class, "destroy"]);

        Route::get("/prompts/", [PromptController::class, "listHistory"]);
        Route::get("/prompts/view", [PromptController::class, "view"]);
        Route::post("/prompts/execute", [PromptController::class, "execute"]);
        Route::post("/prompts", [PromptController::class, "store"]);
        Route::put("/prompts/scores/{id}", [PromptController::class, "updateScore"]);

        Route::get("/roles", [RoleController::class, "index"]);
        Route::get("/roles/{id}", [RoleController::class, "show"]);
        Route::post("/roles", [RoleController::class, "store"]);
        Route::put("/roles/{id}", [RoleController::class, "update"]);
        Route::delete("/roles/{id}", [RoleController::class, "destroy"]);
        Route::post("/roles/{role_id}/permissions", [RoleController::class, "attachPermissions"]);
        Route::get("/roles/{role_id}/permissions", [RoleController::class, "getPermissions"]);
        Route::delete("/roles/{role_id}/permissions", [RoleController::class, "detachPermission"]);

        Route::get("/permissions", [PermissionController::class, "index"]);
        Route::get("/permissions/{id}", [PermissionController::class, "show"]);
        Route::post("/permissions", [PermissionController::class, "store"]);
        Route::put("/permissions/{id}", [PermissionController::class, "update"]);
        Route::delete("/permissions/{id}", [PermissionController::class, "destroy"]);

        Route::get("/users", [UserController::class, "index"]);
        Route::get("/users/{id}", [UserController::class, "show"]);
        Route::get("/users/{id}/prompts", [UserController::class, "listPromptsByUserid"]); // Nuevo listado de prompts.
        Route::post("/users/{id}/prompts", [UserController::class, "updatePrompt"]); // Actualizar el prompt de cada usuario y categoría.
        Route::post("/users/preferences/prompts", [PreferencePromptController::class, "list"]);
        Route::delete("users/preferences/{id}", [PreferencePromptController::class, "destroy"]);
        Route::put("/users/preferences/prompts", [PreferencePromptController::class, "update"]);
        Route::post("/users", [UserController::class, "store"]);
        Route::put("/users/{id}", [UserController::class, "update"]);
        Route::delete("/users/{id}", [UserController::class, "destroy"]);

        Route::get("/users/{id}/roles", [UserController::class, "getRoles"]);
        Route::post("/users/{id}/roles", [UserController::class, "addRole"]);
        Route::delete("/users/{id}/roles", [UserController::class, "removeRole"]);

        Route::get("/languages", [LanguageController::class, "index"]);
        Route::get("/languages/{id}", [LanguageController::class, "show"]);
        Route::post("/languages", [LanguageController::class, "store"]);
        Route::put("/languages/{id}", [LanguageController::class, "update"]);
        Route::delete("/languages/{id}", [LanguageController::class, "destroy"]);

    });
});

Route::get("/countries", [CountryController::class, "index"]);
Route::get("/countries/{id}", [CountryController::class, "show"]);
Route::get("/countries/{id}/levels", [LevelController::class, "listByCountryId"]);
Route::get("/countries/{country_id}/levels/{level_id}/divisions", [DivisionController::class, "list"]);

Route::get("/levels", [LevelController::class, "index"]);
Route::get("/levels/{id}", [LevelController::class, "show"]);

Route::get("/divisions/{id}/cities", [CityController::class, "list"]);

Route::post("food/free", [FoodController::class, "hotMeals"]);
Route::post("food/banks", [FoodController::class, "foodBanks"]);
Route::post("food/delivery", [FoodController::class, "delivery"]);

Route::post("recovery/meetings", [RecoveryController::class, "meetings"]);
Route::post("recovery/detox", [RecoveryController::class, "detox"]);
Route::post("recovery/sober", [RecoveryController::class, "sober"]);

Route::post("/shelter", [ShelterController::class, "general"]);
Route::post("/jobs", [ShelterController::class, "general"]);

// =================================================================================
Route::post("/app/prompt/services", [AppPromptController::class, "services"]);
Route::post("/app/prompt/volunteers", [AppPromptController::class, "volunteers"]);
Route::post("/app/address/verify", [AddressController::class, "verifyAddress"]);
Route::post("/app/place/verify", [AddressController::class, "verifyPlace"]);

//----------- Volunteers and Organization ------------
Route::post("/volunteers", [VolunteerController::class, "store"]);
Route::get("/email/verify/{id}", [EmailVerificationController::class, 'verify']);

//------------------ WebHooks ------------------------
Route::post("/webhooks/donations",[\App\Http\Controllers\Api\WebhookController::class, "donations"]);
