<?php

namespace Database\Seeders;

use App\Models\VolunteerAppPrompt;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class VolunteerAppPromptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Food
        VolunteerAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 1,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically with organizations that offer services related to free food.
                        I am interested in the following categories: Free food, Food Pantry, Soup kitchen.
                        I look for institutions that help people with limited resources.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        VolunteerAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 2,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically with organizations that offer services related to free food.
                        I am interested in the following categories: Free Banks.
                        I look for institutions that help people with limited resources.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        VolunteerAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 3,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically with organizations that offer services related to free food delivery places.
                        I am interested in the following categories: Free food, Food pantry, Soup kitchen.
                        I look for institutions that help people with limited resources.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        // Recovery
        VolunteerAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 1,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically in places of help for addicts, you give me information about places
                        where support group sessions and group therapy are held for people who are in the process
                        of recovering from addictions.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        VolunteerAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 2,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically in places of help for addicts, and give me information about detoxification centers t
                        hat provide medical and therapeutic follow-up to help poor people overcome the initial phase of recovery.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        VolunteerAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 3,
            'prompt' => 'I am looking for volunteer opportunities in $where, day: $day, when: $when,
                        specifically in places of help for addicts, and give me information about "Sober living"
                        halfway houses or residences where people in recovery live together and support each other
                        in maintaining a substance-free lifestyle. These homes provide a structured and supportive
                        environment that facilitates the transition from detox or residential treatment to independent,
                        sober living in the community.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }
}
