<?php

namespace Database\Seeders;

use App\Models\SubCategory;
use App\Models\UserPrompt;
use Illuminate\Database\Seeder;

class UserPromptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subCategories = SubCategory::where("state", 1)->orderBy("id")->get();

        foreach ($subCategories as $subCategory) {
            UserPrompt::create([
                'user_id' => 1,
                'sub_category_id' => $subCategory->id
            ]);
        }
    }
}
