<?php

namespace Database\Seeders;

use App\Models\ServiceAppPrompt;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class ServiceAppPromptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Food
        ServiceAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 1,
            'prompt' => 'Play free food expert, and give me information on free food places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Free food, Food pantry, Soup kitchen,
                        WIC, SNAP and meal programs. translates the value information into the language $language',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 2,
            'prompt' => 'Play free food expert, and give me information on free food places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Food banks.
                        Translates the value information into the language $language',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 1,
            'sub_category_id' => 3,
            'prompt' => 'Act as an expert on free food, and give me information about free food delivery places
                        for people who cannot leave their homes and are of limited resources,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        // Recovery
        ServiceAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 1,
            'prompt' => 'Act as an expert in places of help for addicts, and give me information about places
                        where support group sessions and group therapy are held for people who are in the process
                        of recovering from addictions, taking into account where: $where, day: $day , when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Give me all information in the language $language and the keys of the array in english',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 2,
            'prompt' => 'Become an expert in help places for addicts, and give me information about detoxification centers t
                        hat provide medical and therapeutic follow-up to help poor people overcome the initial phase of recovery.
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website).
                        In a 5-element Json array (unnamed array).
                        Give me all information in the language $language and the keys of the array in english.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 2,
            'sub_category_id' => 3,
            'prompt' => 'Become an expert on places to help addicts, and give me information about Sober living
                        halfway houses or residences where people in recovery live together and support each other
                        in maintaining a substance-free lifestyle. These homes provide a structured and supportive
                        environment that facilitates the transition from detox or residential treatment to independent,
                        sober living in the community.
                        Taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website).
                        In a 5-element Json array (unnamed array).
                        Give me all the information about the values in the language $language and the keys of the array in English.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        // Shelter
        ServiceAppPrompt::create([
            'category_id' => 3,
            'sub_category_id' => 1,
            'prompt' => 'Play shelter service expert, and give me information of places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Short Term Shelter.
                        translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 3,
            'sub_category_id' => 2,
            'prompt' => 'Play shelter service expert, and give me information of places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Parking Shelter.
                        translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 3,
            'sub_category_id' => 3,
            'prompt' => 'Play shelter service expert, and give me information of places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Housing Shelter.
                        translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        // Jobs
        ServiceAppPrompt::create([
            'category_id' => 4,
            'sub_category_id' => 1,
            'prompt' => 'You are a job search assistant specialized in helping people with limited resources,
                        Please provide a list of organizations, community centers, etc. who will offer resume
                        writing services, taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 4,
            'sub_category_id' => 2,
            'prompt' => 'You are a job search assistant specialized in helping people with limited resources,
                        Please provide a list of organizations, community centers, etc. who will offer training
                        and skills development opportunities, taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        ServiceAppPrompt::create([
            'category_id' => 4,
            'sub_category_id' => 3,
            'prompt' => 'You are a job search assistant specialized in helping people with limited resources,
                        Please provide a list of organizations, community centers, etc. who will offer information
                        about available jobs, taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language.',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }
}
