<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Country;
use App\Models\Level;
use Illuminate\Database\Seeder;


class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $americaCountries = [
            'Argentina',
            'Belize',
            'Bahamas',
            'Bolivia',
            'Brazil',
            'Canada',
            'Chile',
            'Colombia',
            'Costa Rica',
            'Cuba',
            'Dominican Republic',
            'Ecuador',
            'El Salvador',
            'Guatemala',
            'Jamaica',
            'Haití',
            'Honduras',
            'United States',
            'Mexico',
            'Nicaragua',
            'Panama',
            'Paraguay',
            'Peru',
            'Uruguay',
            'Venezuela',
        ];

        $levels = [
            'Department',
            'District',
            'Island',
            'Parishes',
            'Province',
            'Region',
            'State',
        ];

        foreach ($americaCountries as $country) {
            Country::create([
                'name' => $country,
                'state' => 1
            ]);
        }

        foreach ($levels as $level) {
            Level::create([
                'name' => $level,
                'state' => 1
            ]);
        }
    }
}
