<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\SubCategory;
use Carbon\Carbon;
use Illuminate\Database\Seeder;


class CategorySubCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $foodCategory = Category::create(['name' => 'Food', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
        $recoveryCategory = Category::create(['name' => 'Recovery', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
        $shelterCategory = Category::create(['name' => 'Shelter', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);
        $jobsCategory = Category::create(['name' => 'Jobs', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()]);

        SubCategory::create([
            'name' => 'Hot Meals',
            'category_id' => $foodCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Food Pantry',
            'category_id' => $foodCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Food Delivery',
            'category_id' => $foodCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Meetings',
            'category_id' => $recoveryCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Detox',
            'category_id' => $recoveryCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Sober Living',
            'category_id' => $recoveryCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Short Term',
            'category_id' => $shelterCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Parking',
            'category_id' => $shelterCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Housing',
            'category_id' => $shelterCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Resume Writing',
            'category_id' => $jobsCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Training',
            'category_id' => $jobsCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);

        SubCategory::create([
            'name' => 'Listing',
            'category_id' => $jobsCategory->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }
}
