<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('donations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('organization_id')->nullable();
            $table->unsignedBigInteger('fundraiser_id')->nullable();
            $table->string('charge_id')->nullable();
            $table->string('partner_donation_id')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->decimal('amount',10,2)->nullable();
            $table->decimal('net_amount',10,2)->nullable();
            $table->string('currency', 10, 2)->nullable();
            $table->string('frequency')->nullable();
            $table->date('donation_date')->nullable();
            $table->text('public_testimony')->nullable();
            $table->text('private_note')->nullable();
            $table->integer('state')->default(1);
            $table->timestamps();

            $table->foreign('organization_id')->references('id')->on('organizations');
            $table->foreign('fundraiser_id')->references('id')->on('fundraisers');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('donations');
    }
};
