<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('volunteers', function (Blueprint $table) {
            $table->dropColumn('username');
            $table->string('phone')->nullable()->change();
            $table->text('bio')->nullable()->change();
            $table->text('skills')->nullable()->change();
            $table->text('interests')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('volunteers', function (Blueprint $table) {
            $table->string('username')->nullable();
            $table->string('phone')->nullable(false)->change();
            $table->text('bio')->nullable(false)->change();
            $table->text('skills')->nullable(false)->change();
            $table->text('interests')->nullable(false)->change();
        });
    }
};
