<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prompts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('where_option_id')->nullable();
            $table->unsignedBigInteger('when_option_id')->nullable();
            $table->unsignedBigInteger('day_option_id')->nullable();
            $table->unsignedBigInteger('operation_id')->nullable();
            $table->unsignedBigInteger('language_id')->nullable();
            $table->unsignedBigInteger('sub_category_id')->nullable();
            $table->integer('score')->nullable();
            $table->string('where_value')->nullable();
            $table->string('day_value')->nullable();
            $table->longText('prompt_input')->nullable();
            $table->longText('prompt_output')->nullable();
            $table->integer('isText');
            $table->integer('state')->default(1);
            $table->timestamps();

            $table->foreign('where_option_id')->references('id')->on('where_options');
            $table->foreign('when_option_id')->references('id')->on('when_options');
            $table->foreign('day_option_id')->references('id')->on('day_options');
            $table->foreign('operation_id')->references('id')->on('operations');
            $table->foreign('sub_category_id')->references('id')->on('sub_categories');
            $table->foreign('language_id')->references('id')->on('languages');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prompts');
    }
};
