<?php

namespace App\Traits;

use Illuminate\Http\JsonResponse;


trait ApiResponder
{
    protected function success(string $message, $data = null, int $code = 200): JsonResponse
    {
        $response = [
            "success" => true,
            "message" => $message,
            "data" => json_decode($data, true),
            'errors' => [],
            'meta' => [
                'timestamp' => formatDate(now()->toISOString())
            ]
        ];

        return response()->json($response, $code);
    }

    protected function error(string $message, int $code = 400, $exception = null): JsonResponse
    {
        if ($exception) {
            $errors['exception'] = [
                'message' => $exception->getMessage(),
            ];
        } else {
            $errors = null;
        }

        return response()->json([
            'success' => false,
            'message' => $message,
            'data' => null,
            'errors' => $errors,
            'meta' => [
                //'code' => $code,
                'timestamp' => now()->toISOString(),
            ],
        ], $code);
    }
}
