<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class AddressVerificationService
{
    protected $googleApiKey;
    protected $hereApiKey;
    protected $geoapifyApiKey;

    public function __construct()
    {
        $this->googleApiKey = 'AIzaSyCEPWzjsD5gk4FiJc72Rw2r9pxBTPzREXQ';
        //$this->googleApiKey = env('GOOGLE_MAPS_API_KEY');
        $this->hereApiKey = env('HERE_API_KEY');
        $this->geoapifyApiKey = env('GEOAPIFY_API_KEY');
    }

    public function verifyAddress($address)
    {

        $results = [
            'google' => $this->verifyWithGoogle($address),
            'here' => $this->verifyWithHere($address),
            'geoapify' => $this->verifyWithGeoapify($address)
        ];

        return $this->analyzeResults($results);
    }

    public function verifyPlace($name)
    {
        $response = Http::get('https://maps.googleapis.com/maps/api/place/findplacefromtext/json', [
                'input' => "$name",
                'inputtype' => 'textquery',
                'fields' => 'formatted_address,name,geometry',
                'key' => 'AIzaSyCEPWzjsD5gk4FiJc72Rw2r9pxBTPzREXQ'
        ]);

        return $response->json();
    }

    private function verifyWithGeoapify($address)
    {
        $response = Http::get('https://api.geoapify.com/v1/geocode/search', [
            'text' => $address,
            'apiKey' => $this->geoapifyApiKey,
        ]);

        $data = $response->json();

        return (!empty($data['features'])? "OK": "ZERO_RESULTS");
    }

    private function verifyWithGoogle($address)
    {
        $response = Http::get('https://maps.googleapis.com/maps/api/geocode/json', [
            'address' => $address,
            'key' => $this->googleApiKey,
        ]);

        $data = $response->json();

        return  $data['status'];
    }

    private function verifyWithHere($address): string
    {
        $response = Http::get('https://geocode.search.hereapi.com/v1/geocode', [
            'q' => $address,
            'apiKey' => $this->hereApiKey,
        ]);

        $data = $response->json();


        return (!empty($data['items'])? "OK": "ZERO_RESULTS");
    }

    private function analyzeResults($results)
    {
        $validCount = 0;

        if( $results['google'] == 'OK' ) $validCount++;
        if( $results['here'] == 'OK' ) $validCount++;
        if( $results['geoapify'] == 'OK' ) $validCount++;

        $valid = $validCount > 1;

        return [
            'valid' => $valid,
            'results' => $results,
        ];
    }
}
