<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;

class Volunteer extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'name',
        'username',
        'email',
        'phone',
        'bio',
        'skills',
        'interests',
        'status',
        'state'
    ];

    protected $hidden = [
        'password',
        'state',
        'created_at',
        'updated_at'
    ];

    public function sendEmailVerificationNotification()
    {
        $this->verification_token = Str::random(40);
        $this->save();

        $verificationUrl = config('app.url') . "/api/email/verify/{$this->id}?token={$this->verification_token}";

        Mail::send('emails.verify-email', ['url' => $verificationUrl], function ($message) {
            $message->to($this->email)
                ->subject('Verify your email address');
        });
    }
}
