<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromptHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'user_id',
        'prompt_id',
        'date',
        'state'
    ];

    protected $hidden = [
        'user_id',
        'prompt_id',
        'state',
        'created_at',
        'updated_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function prompt()
    {
        return $this->belongsTo(Prompt::class, 'prompt_id', 'id');
    }

    public function getDateAttribute($value)
    {
        return Carbon::parse($value)->format('m/d/Y');
    }
}
