<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prompt extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'where_option_id',
        'when_option_id',
        'day_option_id',
        'operation_id',
        'sub_category_id',
        'category_id',
        'language_id',
        'user_id',
        'where_value',
        'day_value',
        'prompt_input',
        'prompt_output',
        'score',
        'isText',
        'state',
        'type'
    ];

    protected $hidden = [
        'user_id',
        'where_option_id',
        'when_option_id',
        'day_option_id',
        'operation_id',
        'sub_category_id',
        'category_id',
        'language_id',
        'state',
        'created_at',
        'updated_at'
    ];

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class);
    }

    public function whereOption()
    {
        return $this->belongsTo(WhereOption::class);
    }

    public function whenOption()
    {
        return $this->belongsTo(WhenOption::class);
    }

    public function dayOption()
    {
        return $this->belongsTo(DayOption::class);
    }

    public function types()
    {
        return $this->hasMany(Type::class);
    }

    public function resources()
    {
        return $this->hasMany(Resource::class);
    }

    public function details()
    {
        return $this->hasMany(Detail::class);
    }

    public function language()
    {
        return $this->belongsTo(Language::class);
    }
}
