<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Level extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'parent_level_id',
        'country_id',
        'name',
        'state'
    ];

    protected $hidden = [
        'state',
        'created_at',
        'updated_at'
    ];

    public function divisions(): HasMany
    {
        return $this->hasMany(Division::class);
    }
}
