<?php

namespace App\Http\Requests;

use App\Traits\ApiResponder;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ServicesAppPromptRequest extends FormRequest
{
    use ApiResponder;

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'where' => 'required',
            'day' => 'required',
            'when' => 'required',
            'language' => 'required',
            'category_id' => 'required',
            'sub_category_id' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'where.required' => 'Required',
            'day.required' => 'Required',
            'when.required' => 'Required',
            'language.required' => 'Required',
            'category_id.required' => 'Required',
            'sub_category_id.required' => 'Required'
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'success' => false,
            'message' => "Validation errors",
            'data' => null,
            'errors' => $errors,
            'meta' => [
                //'code' => $code,
                'timestamp' => now()->toISOString(),
            ],
        ], 400));
    }

}
