<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponder;

class GeneralRequest extends FormRequest
{
    use ApiResponder;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'where' => 'required',
            'day' => 'required',
            'when' => 'required',
            'language' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'where.required' => 'Requerido',
            'day.required' => 'Requerido',
            'when.required' => 'Requerido',
            'language.required' => 'Requerido'
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'success' => false,
            'message' => "Validation errors",
            'data' => null,
            'errors' => $errors,
            'meta' => [
                //'code' => $code,
                'timestamp' => now()->toISOString(),
            ],
        ], 400));
    }

}
