<?php

namespace App\Http\Controllers\Api;

use App\Models\WhereOption;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class WhereOptionController extends Controller
{
    use ApiResponder;

    public function index(): JsonResponse
    {
        $whereOptions = WhereOption::where("state", 1)->orderBy("id")->get();
        return $this->success('Where Options list.', $whereOptions);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $whereOption = WhereOption::create(['name' => $request->name]);
            return $this->success('Where Option created successfully.', $whereOption);

        } catch (Exception $ex) {
            return $this->error('Error creating Where Option.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $whereOption = WhereOption::find($id);

        if (!$whereOption) {
            return $this->error('Where Option not found.');
        }

        return $this->success('Where Option.', $whereOption);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $whereOption = WhereOption::find($id);
            $whereOption->update(['name' => $request->name]);
            $whereOption = WhereOption::find($id);

            return $this->success('Where Option updated successfully.', $whereOption);

        } catch (Exception $ex) {
            return $this->error('Error updating Where Option.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $whereOption = WhereOption::find($id);

        if (!$whereOption) {
            return $this->error('Where Option not found.');
        }

        $whereOption->update(['state' => 0]);

        return $this->success("Where Option deleted successfully.");
    }
}
