<?php

namespace App\Http\Controllers\Api;

use App\Models\WhenOption;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class WhenOptionController extends Controller
{
    use ApiResponder;

    public function index(): JsonResponse
    {
        $whenOptions = WhenOption::where("state", 1)->orderBy("id")->get();
        return $this->success('When Options list.', $whenOptions);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $whenOption = WhenOption::create(['name' => $request->name]);
            return $this->success('When Option created successfully.', $whenOption);

        } catch (Exception $ex) {
            return $this->error('Error creating Day Option.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $whenOption = WhenOption::find($id);

        if (!$whenOption) {
            return $this->error('When Option not found.');
        }

        return $this->success('When Option.', $whenOption);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $whenOption = WhenOption::find($id);
            $whenOption->update(['name' => $request->name]);
            $whenOption = WhenOption::find($id);

            return $this->success('When Option updated successfully.', $whenOption);

        } catch (Exception $ex) {
            return $this->error('Error updating When Option.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $whenOption = WhenOption::find($id);

        if (!$whenOption) {
            return $this->error('When Option not found.');
        }

        $whenOption->update(['state' => 0]);

        return $this->success("When Option deleted successfully.");
    }
}
