<?php

namespace App\Http\Controllers\Api;

use App\Models\Donation;
use App\Models\Fundraiser;
use App\Models\Organization;
use App\Traits\ApiResponder;
use Illuminate\Http\Request;
use Mockery\Exception;

class WebhookController extends Controller
{
    use ApiResponder;

    public function donations(Request $request)
    {
        try {
            $organizationData = $request->toNonprofit;
            $fundraiserData = $request->fromFundraiser;

            $organization = Organization::firstOrCreate([
                'slug' => $organizationData['slug'],
                'ein' => $organizationData['ein'],
                'name' => $organizationData['name']
            ]);

            $fundraiser = Fundraiser::firstOrCreate([
                'code' => $fundraiserData['id'],
                'title' => $fundraiserData['title'],
                'slug' => $fundraiserData['slug']
            ]);

            Donation::create([
                'organization_id' => $organization->id,
                'fundraiser_id' => $fundraiser->id,
                'charge_id' => $request->chargeId,
                'partner_donation_id' => $request->partnerDonationId,
                'first_name' => $request->firstName,
                'last_name' => $request->lastName,
                'email' => $request->email,
                'amount' => $request->amount,
                'net_amount' => $request->netAmount,
                'currency' => $request->currency,
                'frequency' => $request->frequency,
                'donation_date' => $request->donationDate,
                'public_testimony' => $request->publicTestimony,
                'private_note' => $request->privateNote
            ]);

            return $this->success('Donation created successfully.');
        } catch (Exception $ex) {
            return $this->error('Error creating Donation.', 500, $ex);
        }
    }

}
