<?php

namespace App\Http\Controllers\Api;

use App\Models\Country;
use App\Models\Volunteer;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class VolunteerController extends Controller
{
    use ApiResponder;

    public function index()
    {
        $countries = Country::where("state", 1)->orderBy("id")->get();
        return $this->success('Countries list.', $countries);
    }

    public function store(Request $request)
    {
        try {

            $volunteer = Volunteer::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make('password'),
                'phone' => $request->phone,
                'bio' => $request->bio,
                'skills' => $request->skills,
                'interests' => $request->interests,
            ]);

            //$volunteer->sendEmailVerificationNotification();

            return $this->success('Volunteer created successfully.', $volunteer);

        } catch (Exception $ex) {
            return $this->error('Error creating Volunteer.', 500, $ex);
        }
    }

}
