<?php

namespace App\Http\Controllers\Api;

use App\Models\SubCategory;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class SubCategoryController extends Controller
{
    use ApiResponder;

    public function index(): JsonResponse
    {
        $subCategories = SubCategory::where("state", 1)->orderBy("id")->get();
        return $this->success('Sub Categories list.', $subCategories);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $subCategory = SubCategory::create([
                'name' => $request->name,
                'category_id' => $request->category_id,
            ]);
            return $this->success('Sub Category created successfully.', $subCategory);

        } catch (Exception $ex) {
            return $this->error('Error creating Sub Category.', 500, $ex);
        }
    }


    public function show(string $id): JsonResponse
    {
        $subCategory = SubCategory::find($id);

        if (!$subCategory) {
            return $this->error('Sub Category not found.');
        }

        return $this->success('Sub Category.', $subCategory);
    }

    public function showByCategoryId(string $id): JsonResponse
    {
        $subCategories = SubCategory::where("category_id", $id)->orderBy("id")->get();
        return $this->success('Sub Categories list.', $subCategories);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $subCategory = SubCategory::find($id);
            $subCategory->update([
                'name' => $request->name,
                'category_id' => $request->category_id
            ]);
            $subCategory = SubCategory::find($id);

            return $this->success('Category updated successfully.', $subCategory);

        } catch (Exception $ex) {
            return $this->error('Error updating Category.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $subCategory = SubCategory::find($id);

        if (!$subCategory) {
            return $this->error('Sub Category not found.');
        }

        $subCategory->update(['state' => 0]);

        return $this->success("Sub Category deleted successfully.");
    }
}
