<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\GeneralRequest;
use App\Traits\ApiResponder;
use App\Traits\ChatGpt;

class ShelterController extends Controller
{
    use ApiResponder;
    use ChatGpt;

    public function general(GeneralRequest $request) {

        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;
            $subCategory = $request->subCategory;

            $prompt = "Play shelter service expert, and give me information of places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: $subCategory Shelter.
                        translates the value information into the language $language.";

            return $this->success('Shelter list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }
}
