<?php

namespace App\Http\Controllers\Api;

use App\Traits\ApiResponder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    use ApiResponder;
    public function index(): JsonResponse
    {
        $roles = Role::all();

        return $this->success('Roles list.', $roles);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $role = Role::create(['name' => $request->name]);
            return $this->success('Role created successfully.', $role);

        } catch (Exception $ex) {
            return $this->error('Error creating Category.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $role = Role::findById($id);

        if (!$role) {
            return $this->error('Role not found.');
        }

        return $this->success('Role.', $role);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $role = Role::findById($id);
            $role->name = $request->name;
            $role->save();

            return $this->success("Role updated.");

        } catch (Exception $ex) {
            return $this->error('Error updating Category.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        try {
            $role = Role::findById($id);

            if (!$role) {
                return $this->error('Rol no encontrado.', 404);
            }

            $role->delete();

            return $this->success("Role deleted.");
        } catch (Exception $ex) {
            return $this->error('Error deleting role.', 500, $ex);
        }
    }

    public function attachPermissions(Request $request, string $roleId): JsonResponse {

        $role = Role::findById($roleId);

        if (!$role) {
            return $this->error('Rol no encontrado.', 404);
        }

        $permissions = $request->permissions;

        try {
            $role->syncPermissions($permissions);
            return $this->success("Permissions assigned correctly.");
        } catch (Exception $ex) {
            return $this->error('Error assigning permissions.', 500, $ex);
        }
    }

    public function getPermissions(string $roleId): JsonResponse {
        $role = Role::findById($roleId);

        if (!$role) {
            return $this->error('Rol no encontrado.', 404);
        }

        $permissions = $role->permissions;

        return $this->success('Permissions list.', $permissions);
    }

    public function detachPermission(string $roleId, Request $request): JsonResponse
    {
        $role = Role::findById($roleId);

        if (!$role) {
            return $this->error('Rol no encontrado.', 404);
        }

        $permissionIds = $request->permissions;

        try {
            $permissions = Permission::findMany($permissionIds);

            foreach ($permissions as $permission) {
                $role->revokePermissionTo($permission);
            }

            return $this->success("Successfully removed permissions.");
        } catch (Exception $ex) {
            return $this->error('Error removing permissions.', 500, $ex);
        }
    }
}
