<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\GeneralRequest;
use App\Traits\ApiResponder;
use App\Traits\ChatGpt;

class RecoveryController extends Controller
{
    use ApiResponder;
    use ChatGpt;

    public function meetings(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            $prompt = "Act as an expert in places of help for addicts, and give me information about places
                        where support group sessions and group therapy are held for people who are in the process
                        of recovering from addictions, taking into account where: $where, day: $day , when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Give me all information in the language $language and the keys of the array in english";

            return $this->success('Meetings list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

    public function detox(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            //$prompt = "Become an expert in help places for addicts, and give me information about detoxification centers that provide medical and therapeutic follow-up to help poor people overcome the initial phase of recovery. taking into account where: $where, day: $day, when: $when. Please provide the following details: name, address, hours, latitude and longitude (only these data) in a 5 elements Json array (unnamed array) with the format {name, address, hours, latitude, longitude} for each answers. Give me all information in the language $language and the keys of the array in english";

            $prompt = "Become an expert in help places for addicts, and give me information about detoxification centers t
                        hat provide medical and therapeutic follow-up to help poor people overcome the initial phase of recovery.
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website).
                        In a 5-element Json array (unnamed array) with the format {'name', 'address', 'hours', 'latitude', 'longitude'}.
                        Give me all information of the values in the language $language and the keys of the array in english.";

            return $this->success('Detox centers list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

    public function sober(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            $prompt = "Become an expert on places to help addicts, and give me information about 'Sober living'
                       halfway houses or residences where people in recovery live together and support each other
                       in maintaining a substance-free lifestyle. These homes provide a structured and supportive
                       environment that facilitates the transition from detox or residential treatment to independent,
                       sober living in the community.
                       Taking into account where: $where, day: $day, when: $when.
                       Please provide the following details: name, address, hours, latitude and longitude,
                       telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                       return null for telephone and website).
                       In a 5-element Json array (unnamed array) in the format {'name', 'address', 'hours', 'latitude' , 'length'}.
                       Give me all the information about the values ​​in the language $language and the keys of the array in English.";

            return $this->success('Sober living list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }
}
