<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\PreferencePrompt\ListPreferencePromptRequest;
use App\Models\PreferencePrompt;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\Request;

class PreferencePromptController extends Controller
{
    use ApiResponder;

    public function list(ListPreferencePromptRequest $request)
    {
        if($request->has('sub_category_id')) {
            $preference = PreferencePrompt::where('user_id', $request->user_id)->where('sub_category_id', $request->sub_category_id)->firstOrFail();
        } else {
            $preference = PreferencePrompt::where('user_id', $request->user_id)->get();
        }

        if (!$preference) {
            return $this->error('Preference not found.');
        }

        return $this->success('Preference.', $preference);
    }

    public function destroy( $id )
    {
        $preference = PreferencePrompt::find($id);

        if (!$preference) {
            return $this->error('Preference not found.');
        }

        $preference->update(['state' => 0]);

        return $this->success("Preference deleted successfully.");
    }

    public function update(Request $request)
    {
        try {
            $preference = PreferencePrompt::where('user_id', $request->user_id)->where('sub_category_id', $request->sub_category_id)->firstOrFail();

            $preference->update([
                'text' => $request->text
            ]);

            $preference = PreferencePrompt::find($preference->id);

            return $this->success('Preference updated successfully.', $preference);

        } catch (Exception $ex) {
            return $this->error('Error updating Preference.', 500, $ex);
        }
    }
}
