<?php

namespace App\Http\Controllers\Api;

use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionController extends Controller
{
    use ApiResponder;
    public function index(): JsonResponse
    {
        $permissions = Permission::all();

        return $this->success('Permissions list.', $permissions);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $permission = Permission::create(['name' => $request->name]);
            return $this->success('Permission created successfully.', $permission);

        } catch (Exception $ex) {
            return $this->error('Error creating Permission.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $permission = Permission::findById($id);

        if (!$permission) {
            return $this->error('Permission not found.');
        }

        return $this->success('Permission.', $permission);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $permission = Permission::findById($id);
            $permission->name = $request->name;
            $permission->save();

            return $this->success("Permission updated.");

        } catch (Exception $ex) {
            return $this->error('Error updating Permission.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        try {
            $permission = Permission::findById($id);

            if (!$permission) {
                return $this->error('Permission no encontrado.', 404);
            }

            $permission->delete();

            return $this->success("Permission deleted.");
        } catch (Exception $ex) {
            return $this->error('Error deleting Permission.', 500, $ex);
        }
    }
}
