<?php

namespace App\Http\Controllers\Api;

use App\Models\Operation;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class OperationController extends Controller
{
    use ApiResponder;

    public function index(): JsonResponse
    {
        $operations = Operation::where("state", 1)->orderBy("id")->get();
        return $this->success('Operations list.', $operations);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $operation = Operation::create(['name' => $request->name]);
            return $this->success('Operation created successfully.', $operation);

        } catch (Exception $ex) {
            return $this->error('Error creating Operation.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $operation = Operation::find($id);

        if (!$operation) {
            return $this->error('Operation not found.');
        }

        return $this->success('Operation.', $operation);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $operation = Operation::find($id);
            $operation->update(['name' => $request->name]);
            $operation = Operation::find($id);

            return $this->success('Operation updated successfully.', $operation);

        } catch (Exception $ex) {
            return $this->error('Error updating Operation.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $operation = Operation::find($id);

        if (!$operation) {
            return $this->error('Operation not found.');
        }

        $operation->update(['state' => 0]);

        return $this->success("Operation deleted successfully.");
    }
}
