<?php

namespace App\Http\Controllers\Api;

use App\Models\Level;
use App\Traits\ApiResponder;

class LevelController extends Controller
{
    use ApiResponder;

    public function listByCountryId($countryId)
    {
        $levels = Level::whereHas('divisions', function ($query) use ($countryId) {
            $query->where('country_id', $countryId);
        })->distinct()->get(['id','name']);

        return $this->success('Levels list.', $levels);

    }
}
