<?php

namespace App\Http\Controllers\Api;

use App\Models\DayOption;
use App\Models\Language;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\Request;

class LanguageController extends Controller
{
    use ApiResponder;

    public function index()
    {
        $languages = Language::where("state", 1)->orderBy("id")->get();
        return $this->success('Languages list.', $languages);
    }

    public function store(Request $request)
    {
        try {
            $language = Language::create(['name' => $request->name]);
            return $this->success('Language created successfully.', $language);

        } catch (Exception $ex) {
            return $this->error('Error creating Language.', 500, $ex);
        }
    }

    public function show($id)
    {
        $language = Language::find($id);

        if (!$language) {
            return $this->error('Language not found.');
        }

        return $this->success('Language.', $language);
    }

    public function destroy( $id )
    {
        $language = Language::find($id);

        if (!$language) {
            return $this->error('Language not found.');
        }

        $language->update(['state' => 0]);

        return $this->success("Language deleted successfully.");
    }

    public function update(Request $request, string $id)
    {
        try {
            $language = Language::find($id);
            $language->update(['name' => $request->name]);
            $language = Language::find($id);

            return $this->success('Language updated successfully.', $language);

        } catch (Exception $ex) {
            return $this->error('Error updating Language.', 500, $ex);
        }
    }
}
