<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\GeneralRequest;
use App\Traits\ApiResponder;
use App\Traits\ChatGpt;

class JobsController extends Controller
{
    use ApiResponder;
    use ChatGpt;

    public function general(GeneralRequest $request) {

        $prompt = "";

        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;
            $subCategory = $request->subCategory;

            if($subCategory == "Resume Writing") {
                $prompt = "You are a job search assistant specialized in helping people with limited resources,
                            Please provide a list of organizations, community centers, etc. who will offer resume
                            writing services, taking into account where: $where, day: $day, when: $when.
                            Please provide the following details: name, address, hours, latitude and longitude,
                            telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                            return null for telephone and website) in a 5-element Json array (unnamed array).
                            Translates the value information into the language $language.";
            } else if($subCategory == "Training") {
                $prompt = "You are a job search assistant specialized in helping people with limited resources,
                            Please provide a list of organizations, community centers, etc. who will offer training
                            and skills development opportunities, taking into account where: $where, day: $day, when: $when.
                            Please provide the following details: name, address, hours, latitude and longitude,
                            telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                            return null for telephone and website) in a 5-element Json array (unnamed array).
                            Translates the value information into the language $language.";
            } else if($subCategory == "Listings") {
                $prompt = "You are a job search assistant specialized in helping people with limited resources,
                            Please provide a list of organizations, community centers, etc. who will offer information
                            about available jobs, taking into account where: $where, day: $day, when: $when.
                            Please provide the following details: name, address, hours, latitude and longitude,
                            telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                            return null for telephone and website) in a 5-element Json array (unnamed array).
                            Translates the value information into the language $language.";
            }

            return $this->success('Jobs list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }
}
