<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\GeneralRequest;
use App\Traits\ApiResponder;
use App\Traits\ChatGpt;

class FoodController extends Controller
{
    use ApiResponder;
    use ChatGpt;

    public function hotMeals(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            $prompt = "Play free food expert, and give me information on free food places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Free food, Food pantry, Soup kitchen,
                        WIC, SNAP and meal programs. translates the value information into the language $language";

            return $this->success('Hot meals list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

    public function foodBanks(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            $prompt = "Play free food expert, and give me information on free food places,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Includes information from the following resources: Food banks.
                        Translates the value information into the language $language";

            return $this->success('Food banks list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

    public function delivery(GeneralRequest $request)
    {
        try {

            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;

            $prompt = "Act as an expert on free food, and give me information about free food delivery places
                        for people who cannot leave their homes and are of limited resources,
                        taking into account where: $where, day: $day, when: $when.
                        Please provide the following details: name, address, hours, latitude and longitude,
                        telephone, website. (phone and website if they exist, If the telephone and website do not exist,
                        return null for telephone and website) in a 5-element Json array (unnamed array).
                        Translates the value information into the language $language";

            return $this->success('Delivery list.', $this->getChatGptResponse($prompt));

        } catch (\Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }
}
