<?php

namespace App\Http\Controllers\Api;

use App\Models\Country;
use App\Models\Division;
use App\Traits\ApiResponder;

class DivisionController extends Controller
{
    use ApiResponder;

    public function list($countryId, $levelId)
    {
        $divisions = Division::where('level_id', $levelId)->where('country_id', $countryId)->where('state', 1)->orderBy('id')->get();
        return $this->success('Countries list.', $divisions);
    }

}
