<?php

namespace App\Http\Controllers\Api;

use App\Models\Category;
use App\Models\Detail;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;


// TODO: Revisar si este controlador es necesario
class DetailController extends Controller
{
    use ApiResponder;
    public function index(): JsonResponse
    {
        $details = Detail::where("state", 1)->orderBy("id")->get();

        return $this->success('Details list.', $details);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $detail = Category::create(['name' => $request->name]);
            return $this->success('Category created successfully.', $category);

        } catch (Exception $ex) {
            return $this->error('Error creating Category.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $category = Category::with('subcategories')->find($id);

        if (!$category) {
            return $this->error('Category not found.');
        }

        return $this->success('Category.', $category);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $category = Category::find($id);
            $category->update(['name' => $request->name]);
            $category = Category::find($id);

            return $this->success('Category updated successfully.', $category);

        } catch (Exception $ex) {
            return $this->error('Error updating Category.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $category = Category::find($id);

        if (!$category) {
            return $this->error('Category not found.');
        }

        $category->update(['state' => 0]);

        return $this->success("Category deleted successfully.");
    }
}
