<?php

namespace App\Http\Controllers\Api;

use App\Models\DayOption;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\Request;

class DayOptionController extends Controller
{
    use ApiResponder;

    public function index()
    {
        $dayOptions = DayOption::where("state", 1)->orderBy("id")->get();
        return $this->success('Day Options list.', $dayOptions);
    }

    public function store(Request $request)
    {
        try {
            $dayOption = DayOption::create(['name' => $request->name]);
            return $this->success('Day Option created successfully.', $dayOption);

        } catch (Exception $ex) {
            return $this->error('Error creating Day Option.', 500, $ex);
        }
    }

    public function show($id)
    {
        $dayOption = DayOption::find($id);

        if (!$dayOption) {
            return $this->error('Day Option not found.');
        }

        return $this->success('Day Option.', $dayOption);
    }

    public function destroy( $id )
    {
        $dayOption = DayOption::find($id);

        if (!$dayOption) {
            return $this->error('Day Option not found.');
        }

        $dayOption->update(['state' => 0]);

        return $this->success("Day Option deleted successfully.");
    }

    public function update(Request $request, string $id)
    {
        try {
            $dayOption = DayOption::find($id);
            $dayOption->update(['name' => $request->name]);
            $dayOption = DayOption::find($id);

            return $this->success('Day Option updated successfully.', $dayOption);

        } catch (Exception $ex) {
            return $this->error('Error updating Day Option.', 500, $ex);
        }
    }
}
