<?php

namespace App\Http\Controllers\Api;

use App\Models\Category;
use App\Traits\ApiResponder;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    use ApiResponder;
    public function index(): JsonResponse
    {
        $categories = Category::where("state", 1)
                        ->orderBy("id")
                        ->with('subCategories')
                        ->get();

        return $this->success('Categories list.', $categories);
    }

    public function store(Request $request): JsonResponse
    {
        try {
            $category = Category::create(['name' => $request->name]);
            return $this->success('Category created successfully.', $category);

        } catch (Exception $ex) {
            return $this->error('Error creating Category.', 500, $ex);
        }
    }

    public function show(string $id): JsonResponse
    {
        $category = Category::with('subcategories')->find($id);

        if (!$category) {
            return $this->error('Category not found.');
        }

        return $this->success('Category.', $category);
    }

    public function update(Request $request, string $id): JsonResponse
    {
        try {
            $category = Category::find($id);
            $category->update(['name' => $request->name]);
            $category = Category::find($id);

            return $this->success('Category updated successfully.', $category);

        } catch (Exception $ex) {
            return $this->error('Error updating Category.', 500, $ex);
        }
    }

    public function destroy(string $id): JsonResponse
    {
        $category = Category::find($id);

        if (!$category) {
            return $this->error('Category not found.');
        }

        $category->update(['state' => 0]);

        return $this->success("Category deleted successfully.");
    }
}
