<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Api\Controller;
use App\Models\Volunteer;
use Illuminate\Http\Request;

class EmailVerificationController extends Controller
{
    public function verify($id, Request $request)
    {
        $volunteer = Volunteer::findOrFail($id);

        if ($volunteer->verification_token !== $request->query('token')) {
            return response()->json(['message' => 'Token inválido o expirado'], 400);
        }

        $volunteer->email_verified_at = now();
        $volunteer->verification_token = null;
        $volunteer->save();

        return response()->json(['message' => 'Correo verificado correctamente']);
    }
}
