<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Api\Controller;
use App\Models\User;
use App\Traits\ApiResponder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\Sanctum;

class AuthController extends Controller
{
    use ApiResponder;

    public function signup(Request $request) {

        try {
            $user = User::create([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'username' => $request->username,
                'password' => Hash::make($request->password),
                'email' => $request->email,
                'state' => 1
            ]);

            $token = $user->createToken('auth_token')->plainTextToken;

            return $this->success("Welcome",json_encode([
                "user" => $user->toArray(),
                "userToken" => $token,
            ]));

        } catch (\Exception $e) {
            return $this->error('Error creating user: ', 500, $e);
        }
    }

    public function login(Request $request) {

        $credentials = $request->only('username', 'password');

        if (!Auth::guard('web')->attempt($credentials)) {
            return $this->error('Incorrect credentials', 401);
        }

        $user = User::where('username', $request->username)->firstOrFail();
        $token = $user->createToken('auth_token')->plainTextToken;

        return $this->success("Welcome", json_encode([
            "user" => $user->toArray(),
            "userToken" => $token,
        ]));
    }

    public function logout() {

        $token = request()->bearerToken();
        $model = Sanctum::$personalAccessTokenModel;
        $accessToken = $model::findToken($token);
        $accessToken->delete();

        return $this->success(("You have successfully logged out!"));
    }
}
