<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\ServicesAppPromptRequest;
use App\Http\Requests\VolunteerAppPromptRequest;
use App\Models\ServiceAppPrompt;
use App\Models\VolunteerAppPrompt;
use App\Traits\ApiResponder;
use App\Traits\ChatGpt;
use Exception;
use Illuminate\Http\JsonResponse;

class AppPromptController extends Controller
{
    use ApiResponder;
    use ChatGpt;

    public function services(ServicesAppPromptRequest $request): JsonResponse
    {
        try {
            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;
            $categoryId = $request->category_id;
            $subCategoryId = $request->sub_category_id;

            $text = ServiceAppPrompt::select('prompt')
                ->where('category_id', $categoryId)
                ->where('sub_category_id', $subCategoryId)
                ->first();

            $prompt = str_replace(['$where', '$day', '$when', '$language'], [$where, $day, $when, $language], $text['prompt']);

            $response = $this->getChatGptResponse($prompt);

            return $this->success('Response.', $response);

        } catch (Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

    public function volunteers(VolunteerAppPromptRequest $request): JsonResponse
    {

        try {
            $where = $request->where;
            $day = $request->day;
            $when = $request->when;
            $language = $request->language;
            $categoryId = $request->category_id;
            $subCategoryId = $request->sub_category_id;

            $text = ServiceAppPrompt::select('prompt')
                ->where('category_id', $categoryId)
                ->where('sub_category_id', $subCategoryId)
                ->first();

            $prompt = str_replace(['$where', '$day', '$when', '$language'], [$where, $day, $when, $language], $text['prompt']);

            $response = $this->getChatGptResponse($prompt);

            return $this->success('Response.', $response);

        } catch (Exception $e) {
            return $this->error('Error occurred', 500, $e);
        }
    }

}
