<?php

namespace App\Http\Controllers\Api;

use App\Models\City;
use App\Services\AddressVerificationService;
use App\Traits\ApiResponder;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    use ApiResponder;
    protected  $addressService;

    public function __construct(AddressVerificationService $adressService)
    {
        $this->addressService = $adressService;
    }

    public function verifyAddress(Request $request)
    {
        $result = $this->addressService->verifyAddress($request->address);

        return $this->success('Address verify.', json_encode($result));
    }

    public function verifyPlace(Request $request)
    {
        $result = $this->addressService->verifyPlace($request->name);

        return $this->success('Place verify.', json_encode($result));
    }

}
