<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Auth\AuthenticationException;
use App\Traits\ApiResponder;
use Throwable;

class Handler extends ExceptionHandler
{
    use ApiResponder;
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $e)
    {
        if ($e instanceof CustomAuthorizationException) {
            return $this->error('Error de autorización', 401, $e);
        } else  if ($e instanceof AuthenticationException) {
            return $this->error('Error de autentificación', 403, $e);
        } else {
            return $this->error('Error: ',500, $e);
        }

    }
}
